﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucTrendGraph.ascx.cs" Inherits="ucTrendGraph" %>

<script src="highcharts/highcharts.js"></script>
<script src="highcharts/modules/exporting.js"></script>

<script type="text/javascript">

    var ucTrendGraphJS = {

        show: function (patient_id, mid, intake_id, filter, highlight) {
            var _me = this;
            App.direct.UCTRENDGRAPH.LoadTrendGraph(patient_id, mid, intake_id, filter, {
                success: function (results) {
                    _me._render(results, highlight);
                    App.winTrendGraph.show();
                }
            });
        },

        //render: function (mid, div) {
        //    var _me = this;

        //    App.direct.UCTRENDGRAPH.LoadTrendGraph(mid, {
        //        success: function (results) {
        //            _me._render(results);
        //            $(div).html($('div[id$="divUCTrendContainer"]').html());
        //        }
        //    });
        //},

        _render: function (result, highlight) {
            var _me = this;

            if (result != null) {
                if (typeof (result.mid) === "undefined") {
                    $('div[id$="divUCTrendContainer"]').html('<span style="font-weight: bold;">There is no score data available for this instrument.</span>');
                }
                else {

                    //render the trend graph
                    $('div[id$="divUCTrendContainer"]').highcharts({
                        title: {
                            text: result.module,
                            x: -20 //center
                        },
                        exporting: 
                        { 
                            enabled:false
                        },
                        chart: {
                            zoomType: 'x'
                        },
                        credits: {
                            enabled: false
                        },
                        xAxis: {
                            type: 'datetime',
                            //minTickInterval: 24 * 3600 * 1000,
                            title: {
                                text: 'Date'
                            },
                            dateTimeLabelFormats: {
                                millisecond: '%b %e %H:%M:%S',
                                second: '%b %e %H:%M:%S',
                                minute: '%b %e %H:%M',
                                hour: '%b %e %H:%M',
                                day: '%b %e',
                                week: '%b %e',
                                month: '%b \'%y',
                                year: '%Y'
                            }
                        },
                        yAxis: {
                            title: {
                                text: 'Score'
                            }
                        },
                        legend: {
                            layout: 'vertical',
                            align: 'right',
                            verticalAlign: 'middle',
                            borderWidth: 0
                        },
                        series: result.scores
                    });

                    /*Set visibility for highlight serie*/
                    if (highlight != '') {
                        var chart = $('div[id$="divUCTrendContainer"]').highcharts();
                        $(chart.series).each(function (idx, ele) {
                            if(ele.name != highlight) {
                                ele.setVisible();
                            }
                        });
                    }

                    // listens to the resizer 
                    _me._resize();

                }
            }
            else {
                $('div[id$="divUCTrendContainer"]').html('<span style="font-weight: bold;">There is no score data available for this instrument.</span>');
            }
        },

        _resize: function () {
            var chart = $('div[id$="divUCTrendContainer"]').highcharts();

            var w = App.winTrendGraph.width - 30,
                h = App.winTrendGraph.height - 30;

            if (arguments.length > 0) {
                w = arguments[1] - 30;
                h = arguments[2] - 30;
            }

            chart.setSize(w, h, true);
            chart.redraw();
        },

        /*init: function () {
            var chart = $('div[id$="divUCTrendContainer"]').highcharts();
            $('#divResizer').each(function () {
                chart.setSize(
                    this.offsetWidth - 20,
                    this.offsetHeight - 20,
                    false
                );
            });
        }*/
    };

    /*ucTrendGraphJS.init();*/

</script>

<ext:Window ID="winTrendGraph" runat="server"
    BodyPadding="6"
    Width="680"
    MinWidth="620"
    MinHeight="420"
    Height="500"
    Hidden="true"
    IDMode="Static"
    Layout="VBoxLayout"
    Anchor="100%"
    Constrain="true"
    
    Modal="true"
    Collapsible="false"
    Resizable="false"
    Maximizable="false"
    Draggable="false" 
    XOnEsc="Ext.emptyFn">
    <LayoutConfig>
        <ext:VBoxLayoutConfig Align="Stretch" />
    </LayoutConfig>
    <BottomBar>
         <ext:Toolbar runat="server">
            <Items>
                <ext:Button runat="server" Text="Close" Icon="None" Handler="App.winTrendGraph.hide();" />
            </Items>
        </ext:Toolbar>
    </BottomBar>
    <Items>
        <ext:Panel ID="pnlTrendGraph"
            IDMode="Static"
            runat="server"
            Border="false"
            Flex="1">
            <Content>
                <div id="divUCTrendContainer" style="min-width: 100%; min-height: 100%; max-width: 100%; max-height: 100%; margin: 0 auto"></div>
            </Content>
        </ext:Panel>
    </Items>
    <Listeners>
        <Resize Fn="ucTrendGraphJS._resize" />
    </Listeners>
</ext:Window>



